/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.block.def;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public interface BlockDefinition {
    public static final Map<String, Factory<?>> MAP = Maps.newConcurrentMap();
    public static final List<Factory<?>> FACTORIES = Lists.newLinkedList();

    public static void registerFactory(Factory<?> factory) {
        MAP.put(factory.getId(), factory);
        if ("Block".equals(factory.getId())) {
            FACTORIES.add(factory);
        } else {
            FACTORIES.add(0, factory);
        }
    }

    public static BlockDefinition fromNBT(class_2487 tag) {
        Factory<?> factory = MAP.get(tag.method_10558("Type"));
        if (factory == null) {
            return null;
        }
        return factory.fromNBT(tag);
    }

    public static BlockDefinition fromBlock(class_2680 state, class_2586 blockEntity, class_4538 level, class_2338 pos) {
        for (Factory<?> factory : FACTORIES) {
            Object supplier = factory.fromBlock(state, blockEntity, level, pos);
            if (supplier == null) continue;
            return supplier;
        }
        return null;
    }

    public static BlockDefinition fromItem(class_1799 stack, @Nullable class_1750 context) {
        if (!stack.method_7960()) {
            for (Factory<?> factory : FACTORIES) {
                Object supplier = factory.fromItem(stack, context);
                if (supplier == null) continue;
                return supplier;
            }
        }
        return null;
    }

    public Factory<?> getFactory();

    @Environment(value=EnvType.CLIENT)
    public class_1087 model();

    @Environment(value=EnvType.CLIENT)
    public class_4730 renderMaterial(@Nullable class_2350 var1);

    public void save(class_2487 var1);

    @Environment(value=EnvType.CLIENT)
    public boolean canRenderInLayer(class_1921 var1);

    public boolean canOcclude();

    @Environment(value=EnvType.CLIENT)
    public int getColor(class_2680 var1, class_1920 var2, class_2338 var3, int var4);

    public class_2561 getDescription();

    public void place(class_1937 var1, class_2338 var2);

    public class_1799 createItem(class_239 var1, class_1922 var2, @Nullable class_2338 var3, @Nullable class_1657 var4);

    public class_2680 getBlockState();

    default public BlockDefinition getCamoDefinition() {
        return null;
    }

    public static BlockDefinition getCamo(BlockDefinition definition) {
        BlockDefinition camo = definition.getCamoDefinition();
        while (camo != null && camo != definition) {
            definition = camo;
            camo = definition.getCamoDefinition();
        }
        return definition;
    }

    default public int getLightEmission(class_1922 level, class_2338 pos) {
        return this.getBlockState().method_26213();
    }

    public class_2498 getSoundType();

    public static interface Factory<T extends BlockDefinition> {
        public T fromNBT(class_2487 var1);

        public String getId();

        @Nullable
        public T fromBlock(class_2680 var1, class_2586 var2, class_4538 var3, class_2338 var4);

        @Nullable
        public T fromItem(class_1799 var1, @Nullable class_1750 var2);
    }
}

